//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "PassthroughUseCasePage.h"
#import "NTAG5_NFC_LIB.h"
#import "Config.h"

@interface PassthroughUseCasePage ()

@end

@implementation PassthroughUseCasePage

- (void)viewDidLoad {
    [super viewDidLoad];
    [self SetupUIElements];
    
    [self InitUseCase];
}

- (void)InitUseCase {
    [[PassthroughUseCase sharedInstance] InitializeSRAMData:^(NSData * _Nonnull aData, NSString * _Nonnull text) {
        self -> _topText.text = text;
    } onFailure:^(NSError * _Nonnull error) {
        NSLog(@"Failure Initializing");
    }];
}

- (IBAction)setI2cSlaveModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CSlave:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setI2cMasterModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setI2CMaster:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)setGPIOPWMModeOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] setGPIOPWM:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)getUseCaseCongifOptionSelected:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[Config sharedInstance] getUseCaseConfig:^(NSData *aData) {
        } onFailure:^(NSError *error) {
        }];
        
    }else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

- (IBAction)startDemoButtonClick:(UIButton *)sender {
    
    [[NTAG5_NFC_LIB sharedInstance] initSession:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    NSLog(@"Waiting for connection...");
    while ([[NTAG5_NFC_LIB sharedInstance] isConnect] == 0){}
       
    
    if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 3){
        NSLog(@"Connected!!!");
        
        [[PassthroughUseCase sharedInstance] SRAMLoop:^(NSData *aData, bool * isWrite) {
            
            [self writeLog:isWrite direction:aData];
            
        } onFailure:^(NSError * _Nonnull error) {
            
            NSLog(@"Failure SRAM Loop");
        }];
        
    } else if([[NTAG5_NFC_LIB sharedInstance]isConnect] == 4){
        NSLog(@"Not connected!!!");
        [[NTAG5_NFC_LIB sharedInstance] errorMessage:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    }
}

/*---------------------- UI METHODS ----------------------*/

- (void) writeLog: (bool *) isWrite direction: (NSData *) resp{
    
    [[NSOperationQueue mainQueue] addOperationWithBlock:^{
        
        NSString * sbuf = [[Utils alloc] printNSDataBytesToHexString:resp];
        
        
        if (isWrite){
            self-> _textDirection.text = @"Direction: NFC -> RF";
        }
        else{
            self-> _textDirection.text = @"Direction: RF -> NFC";
            self-> _bottomText.text = sbuf;
        }
        
        //Get the file path
        NSString *documentsDirectory = [NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES) objectAtIndex:0];
        NSString *fileName = [documentsDirectory stringByAppendingPathComponent:@"PassthroughLogs.txt"];

        //create file if it doesn't exist
        if(![[NSFileManager defaultManager] fileExistsAtPath:fileName])
            [[NSFileManager defaultManager] createFileAtPath:fileName contents:nil attributes:nil];

        //append text to file (you'll probably want to add a newline every write)
        NSFileHandle *file = [NSFileHandle fileHandleForUpdatingAtPath:fileName];
        [file seekToEndOfFile];
        [file writeData:[sbuf dataUsingEncoding:NSUTF8StringEncoding]];
        [file closeFile];
    }];
}

-(void)HideWhenTappedAnywhere{
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    _configDropDownList.hidden = YES;
}

- (void)setAutoHideDropDownMenuListener {
    
    UITapGestureRecognizer *singleTap   = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(HideWhenTappedAnywhere)];
    
    singleTap.numberOfTapsRequired = 1;
    
    [self.MainDemoView setUserInteractionEnabled:YES];
    [self.MainDemoView addGestureRecognizer:singleTap];
}

- (void)SetupUIElements {
    _topView.layer.cornerRadius = 8;
    _topView.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _topView.layer.borderWidth = 0.75;
    _topView.backgroundColor = UIColor.whiteColor;
    
    _bottomView.layer.cornerRadius = 8;
    _bottomView.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _bottomView.layer.borderWidth = 0.75;
    _bottomView.backgroundColor = UIColor.whiteColor;
    
    _startDemoButton.layer.cornerRadius = 8;
    
    _topText.backgroundColor = UIColor.whiteColor;
    _topText.textColor = UIColor.darkGrayColor;
    _topText.userInteractionEnabled = false;
    _bottomText.userInteractionEnabled = false;
    
    _bottomText.scrollEnabled = YES;
    _bottomText.userInteractionEnabled = YES;
    _bottomText.selectable = NO;
    _topText.scrollEnabled = YES;
    _topText.userInteractionEnabled = YES;
    _topText.selectable = NO;
    
    _configDropDownList.userInteractionEnabled = true;
    _configDropDownList.backgroundColor = UIColor.whiteColor;
    _configDropDownList.layer.borderColor = [UIColor lightGrayColor].CGColor;
    _configDropDownList.layer.borderWidth = 0.75;
    _configDropDownList.hidden = true;
    
    [self setAutoHideDropDownMenuListener];
}

- (IBAction)navBarButtonClick:(id)sender {
    CATransition *animation = [CATransition animation];
    
    animation.type = kCATransitionReveal;
    animation.duration = 0.1;
    
    [_configDropDownList.layer addAnimation:animation forKey:nil];
    
    if (_configDropDownList.hidden == false)
        _configDropDownList.hidden = true;
    else
        _configDropDownList.hidden = false;
}

@end
